#version 120

uniform sampler2D tex0;

varying vec2 fragTexCoord; 

void main() 
{
	vec2 uvs = vec2(fragTexCoord.s * 1024.0, fragTexCoord.t * 1024.0);

	vec2 uv_pix = vec2(floor(uvs.s), floor(uvs.t));

	vec2 uv_ratio = uvs - uv_pix;
	vec2 uv_ratio_inv = 1.0 - uv_ratio;
	
	float one_pix = 0.0009765625; // 1 div 1024
	
	uv_pix *= one_pix; // div 1024
	
	float col = (texture2D(tex0, uv_pix).r * uv_ratio_inv[0]  +  texture2D(tex0, vec2(uv_pix[0]+one_pix, uv_pix[1])).r * uv_ratio[0]  ) *uv_ratio_inv[1] + (texture2D(tex0, vec2(uv_pix[0], uv_pix[1]+one_pix)).r * uv_ratio_inv[0]  +  texture2D(tex0, vec2(uv_pix[0]+one_pix, uv_pix[1]+one_pix)).r * uv_ratio[0]  ) *uv_ratio[1];
	gl_FragColor = vec4(0.0, 0.0, 0.0, col);
}
